c
c $Header: /home/cherny/qtl/multisim/multisim-distrib/RCS/multisim.f,v 2.2 1998/03/23 18:35:46 cherny Exp $
c
c     This program simulates sibling data (any size sibships),
c     any number of markers, chromosomes, QTL, phenotypes, alleles.
c
c     Copyright (c) 1995,1996,1997,1998    Stacey Cherny
c
c     This program is provided without warranty.  Permission is granted to
c     redistribute the program provided the above copywrite notice is retained.
c     Permission is also granted to modify the program, but such changes must
c     be documented and those changes emailed to: Stacey.Cherny@Colorado.EDU.
c
c $Log: multisim.f,v $
c Revision 2.2  1998/03/23 18:35:46  cherny
c Added some copywrite information.
c
c Revision 2.1  1998/03/23 18:16:10  cherny
c *** empty log message ***
c
c
      program multisim
      implicit real*8 (a-h,o-z)
      parameter(ndmark=11,ndqtl=3,ndchr=2,ndeppr=6,igunit=120,ipunit=3)
      parameter(ndphen=6,ndall=9,igenun=4,iqtlun=10,ibdtun=11,
     $     ibdmun=12,ignpun=130,ig1pun=140)
      real*8 qtles(ndchr,ndqtl,3,ndphen),qtlloc(ndchr,ndqtl),
     $     marker(ndchr,ndmark),episcr(ndeppr,3,3,ndphen),
     $     allfr(ndchr,ndmark,ndall),callfr(ndchr,ndmark,ndall),
     $     qtlfr(ndchr,ndqtl),
     $     gsq(ndphen),hsq(ndphen),csq(ndphen),
     $     plycor(ndphen,ndphen),shrcor(ndphen,ndphen),
     $     unicor(ndphen,ndphen)
      integer nchr,nmark(ndchr),nqtl(ndchr),nfam,iepi(ndeppr,2,2,ndphen)
      integer nall(ndchr,ndmark)
      character*72 title
      open(igunit+1,file='pedigree.dat',status='unknown')
      open(igunit+2,file='pedigree-2.dat',status='unknown')
      open(igunit+3,file='pedigree-3.dat',status='unknown')
      open(igunit+4,file='pedigree-4.dat',status='unknown')
      open(igunit+5,file='pedigree-5.dat',status='unknown')
      open(igunit+6,file='pedigree-6.dat',status='unknown')
      open(ipunit,file='pheno.dat',status='unknown')
      open(igenun,file='genotype.dat',status='unknown')
      open(iqtlun,file='qtl-genotypes.dat',status='unknown')
      open(ibdtun,file='complete-info.dat',status='unknown')
      open(ibdmun,file='complete-marker-info.dat',status='unknown')
      open(ignpun+1,file='no-parents.dat',status='unknown')
      open(ignpun+2,file='no-parents-2.dat',status='unknown')
      open(ignpun+3,file='no-parents-3.dat',status='unknown')
      open(ignpun+4,file='no-parents-4.dat',status='unknown')
      open(ignpun+5,file='no-parents-5.dat',status='unknown')
      open(ignpun+6,file='no-parents-6.dat',status='unknown')
      open(ig1pun+1,file='one-parent.dat',status='unknown')
      open(ig1pun+2,file='one-parent-2.dat',status='unknown')
      open(ig1pun+3,file='one-parent-3.dat',status='unknown')
      open(ig1pun+4,file='one-parent-4.dat',status='unknown')
      open(ig1pun+5,file='one-parent-5.dat',status='unknown')
      open(ig1pun+6,file='one-parent-6.dat',status='unknown')
      call rparam(gsq,qtles,qtlloc,marker,episcr,title,
     $     nchr,nmark,nqtl,nfam,nsel,iseed,nepipr,iepi,
     $     allfr,callfr,qtlfr,hsq,csq,nall,plycor,shrcor,
     $     unicor,nsibsz,npheno,ifamic)
      call sim(gsq,qtles,qtlloc,marker,episcr,title,
     $     nchr,nmark,nqtl,nfam,nsel,iseed,nepipr,iepi,
     $     allfr,callfr,qtlfr,hsq,csq,nall,plycor,shrcor,
     $     unicor,nsibsz,npheno,ifamic)
      stop
      end
c
      subroutine sim(gsq,qtles,qtlloc,marker,episcr,title,
     $     nchr,nmark,nqtl,nfam,nsel,iseed,nepipr,iepi,
     $     allfr,callfr,qtlfr,hsq,csq,nall,plycor,shrcor,
     $     unicor,nsibsz,npheno,ifamic)
      implicit real*8 (a-h,o-z)
      parameter(ndmark=11,ndqtl=3,ndchr=2,ndfam=5000,iqtlun=10,
     $     ibdtun=11,ibdmun=12,ignpun=130,ig1pun=140,
     $     ndeppr=6,igunit=120,ipunit=3,igenun=4,ndphen=6,ndsibz=4,
     $     ndall=9,ndimc=ndsibz*ndphen,ndimrv=((ndimc+1)*(ndimc+2))/2)
      real*8 lambda(ndchr,ndmark+ndqtl-1),theta(ndchr,ndmark+ndqtl-1),
     $     map(ndchr,ndmark+ndqtl),mapes(ndchr,ndmark+ndqtl),
     $     qtlscr(ndfam,ndsibz,ndphen),dummy(ndfam)
      real*8 qtles(ndchr,ndqtl,3,ndphen),qtlloc(ndchr,ndqtl),
     $     marker(ndchr,ndmark),episcr(ndeppr,3,3,ndphen),
     $     phensc(ndfam,ndsibz,ndphen),
     $     allfr(ndchr,ndmark,ndall),callfr(ndchr,ndmark,ndall),
     $     qtlfr(ndchr,ndqtl),bcalfr(ndchr,ndmark+ndqtl,ndall),
     $     gsq(ndphen),hsq(ndphen),csq(ndphen),
     $     qtlv(ndphen),polyv(ndphen),sharev(ndphen),uniqv(ndphen),
     $     plycor(ndphen,ndphen),shrcor(ndphen,ndphen),
     $     unicor(ndphen,ndphen),cfr(ndall),
     $     tqtlsc(ndfam*ndsibz,ndphen),tmp(ndfam*ndsibz),
     $     xbar(ndphen),std(ndphen),ssp(ndphen,ndphen),
     $     cormat(ndphen,ndphen),
     $     hrgh(ndphen,ndphen),crcc(ndphen,ndphen),eree(ndphen,ndphen),
     $     covmat(ndimc,ndimc),a(ndimc),refvec(ndimrv),z(ndimc),
     $     wt(ndfam*ndsibz)
      integer igeno(2+ndsibz,2,ndchr,ndmark+ndqtl)
      integer gamete(2,ndchr,ndmark+ndqtl),
     $     genoty(ndfam,2+ndsibz,2,ndchr,ndmark),genout(ndchr*ndmark*2)
      integer nchr,nmark(ndchr),nqtl(ndchr),nfam,nloc(ndchr),
     $     qtlgty(ndfam,2+ndsibz,2,ndchr,ndqtl),iepi(ndeppr,2,2,ndphen)
      integer nall(ndchr,ndmark)
      integer nball(ndchr,ndmark+ndqtl)
      integer itibd(ndsibz,2,ndchr,ndmark+ndqtl)
      logical qtl(ndchr,ndmark+ndqtl)
      character*4 cmgeno,cfgeno
      external g05ddf,g05cbf,g05caf
      external g05eaf,g05ezf
      cmgeno=' 1 2'
      cfgeno=' 3 4'
c
c     sets the basic generator routine, g05cbf, to a repeatable initial state
c     which is given as user input
c
      call g05cbf(iseed)
c
c     Put the markers and QTLs into a single vector, map
c     Contents of map are distances from head of chromosome,
c     which is the same as qtlloc() and marker()
c
c
c     nloc is the number of "known" points along the chromosome,
c     which includes the number of markers + QTLs
c
c     begin a loop across chromosomes
      do 747 ichr=1,nchr
         nloc(ichr)=nmark(ichr)+nqtl(ichr)
c
c     placing a large value for the last QTL + 1 to make the loop
c     below which places the markers and QTLs into the same array
c     work (sloppy but does the job)
         qtlloc(ichr,nqtl(ichr)+1)=1d10
c
         iqtl=1
         imark=1
         do 9797 k=1,nloc(ichr)
            if (qtlloc(ichr,iqtl).lt.marker(ichr,imark)) then
               map(ichr,k)=qtlloc(ichr,iqtl)
               qtl(ichr,k)=.true.
               nball(ichr,k)=2
               bcalfr(ichr,k,1)=1-qtlfr(ichr,iqtl)
               bcalfr(ichr,k,2)=1d0
               iqtl=iqtl+1
            else
               map(ichr,k)=marker(ichr,imark)
               qtl(ichr,k)=.false.
               nball(ichr,k)=nall(ichr,imark)
               do 19798 kl=1,nball(ichr,k)
                  bcalfr(ichr,k,kl)=callfr(ichr,imark,kl)
19798          continue
               imark=imark+1
            end if
 9797    continue
c
c     compute the values of theta between each pair of markers
c     (markers includes QTLs)
c
         do 477 j=1,nloc(ichr)-1
            lambda(ichr,j) = (map(ichr,j+1) - map(ichr,j))/100d0
            theta(ichr,j) = .5d0 * ( 1d0 - dexp(-2d0*lambda(ichr,j)) )
 477     continue
c     end the loop across chromosomes
 747  continue
c
c     Repeat the loop below for each family created.
c     Outside loop is for each set of offspring.
c     Next, male and female gametes.
c     Inside loop forms the gametes.
c
c     For each family
      do 374 k=1,nfam
c     and each chromosome
         do 898 ichr=1,nchr
c     and each locus on each chromosome
            do 699 iloc=1,nloc(ichr)
c
c     Create random marker and QTL genotypes for mother and father.
c     This assumes completely random distribution of parental genotypes.
c
c     Copy the cumulative allele frequency for the given chromosome
c     and marker/qtl into the vector cfr(ndall)
               nallt=nball(ichr,iloc)
               do 13275 ijkl=1,nallt
                  cfr(ijkl)=bcalfr(ichr,iloc,ijkl)
13275          continue
c     for mother (1) and father (2)
               do 375 i=1,2
c     maternal (1) and paternal (2) chromosomes
                  do 1375 j=1,2
                     igeno(i,j,ichr,iloc)=irgen(cfr,nallt,ndall)
 1375             continue
 375           continue
 699        continue
c
c     Parental random genotypes are now created.
c
c
c     Now create sibs.  Their genotypes are in the same array as
c     the parental genotypes, continuing from i and j = 3 to nsibsz+2.
c
            do 35401 isib=3,nsibsz+2
c     For the maternal gamete, then the paternal,
               do 35403 iparen=1,2
c
c     Randomly determine whether gamete at marker 1 is grandmaternal
c     or grandpaternal.
c
                  ipsw=nint(g05caf(x))+1
                  igeno(isib,iparen,ichr,1)=igeno(iparen,ipsw,ichr,1)
                  itibd(isib-2,iparen,ichr,1)=ipsw
c
c     Once you have the chromosome picked, generate crossovers.
c
                  do 35402 iloc=2,nloc(ichr)
                     dice=g05caf(x)
                     if (dice.lt.theta(ichr,iloc)) then
c     generate crossover
                        ipsw = iabs(ipsw-2)+1
                     end if
                     igeno(isib,iparen,ichr,iloc)=
     $                    igeno(iparen,ipsw,ichr,iloc)
c     itibd contains, for each sib, whether for the maternal
c     allele (iparen = 1), the grandmaternal (ipsw=1) or grandpaternal
c     (ipsw=2) allele was inherited and the same for the paternal allele
c     (iparen = 2).
                     itibd(isib-2,iparen,ichr,iloc)=ipsw
35402             continue
35403          continue
35401       continue
c     
c     Pull the markers out of the igeno array
c     and put them in the genoty array
c     and pull out the QTLs and put them in qtlgty
c
            iii=1
            jjj=1
            do 2828 ii=1,nloc(ichr)
               if (.not.qtl(ichr,ii)) then
                  do 55904 ijijij=1,nsibsz+2
                     do 55905 ijijik=1,2
                        genoty(k,ijijij,ijijik,ichr,iii)=
     $                       igeno(ijijij,ijijik,ichr,ii)
55905                continue
55904             continue
                  iii=iii+1
               else
                  do 65904 ijijij=1,nsibsz+2
                     do 65905 ijijik=1,2
                        qtlgty(k,ijijij,ijijik,ichr,jjj)=
     $                       igeno(ijijij,ijijik,ichr,ii)
65905                continue
65904             continue
                  jjj=jjj+1
               end if
 2828       continue
c     this ends the loop across chromosomes
 898     continue
c
c     Write out the complete information genotypes
c     for all markers and QTLs.
c
         do 59124 isbctr=1,nsibsz
            iallel=0
            do 59125 ichr=1,nchr
               do 59126 ilocus=1,nloc(ichr)
                  do 59127 iparen=1,2
                     iallel=iallel+1
                     if(iparen.eq.1) then
                        genout(iallel)=
     $                       itibd(isbctr,iparen,ichr,ilocus)
                     else
                        genout(iallel)=
     $                       itibd(isbctr,iparen,ichr,ilocus)+2
                     end if
59127             continue
59126          continue
59125       continue
            write(ibdtun,12747)
     $           k+ifamic,isbctr+2,(genout(ij),ij=1,iallel)
59124    continue
         write(ibdtun,12748) k+ifamic,(cmgeno,ij=1,iallel/2)
         write(ibdtun,12749) k+ifamic,(cfgeno,ij=1,iallel/2)
c
c     Write out the complete information genotypes
c     for just the markers.
c
         do 89424 isbctr=1,nsibsz
            iallel=0
            do 89425 ichr=1,nchr
               do 89426 ilocus=1,nloc(ichr)
                  do 89427 iparen=1,2
                     if(.not.qtl(ichr,ilocus)) then
                        iallel=iallel+1
                        if(iparen.eq.1) then
                           genout(iallel)=
     $                          itibd(isbctr,iparen,ichr,ilocus)
                        else
                           genout(iallel)=
     $                          itibd(isbctr,iparen,ichr,ilocus)+2
                        end if
                     end if
89427             continue
89426          continue
89425       continue
            write(ibdmun,12747)
     $           k+ifamic,isbctr+2,(genout(ij),ij=1,iallel)
89424    continue
         write(ibdmun,12748) k+ifamic,(cmgeno,ij=1,iallel/2)
         write(ibdmun,12749) k+ifamic,(cfgeno,ij=1,iallel/2)
12747    format(i5,i2,' 2 1 2 0 ',100i2)
12748    format(i5,' 1 0 0 2 0 ',50a4)
12749    format(i5,' 2 0 0 1 0 ',50a4)
c
c     Write out the genotypes of markers and QTLs, in order.
c     Also write a QTL genotype file.
c
         do 62124 iind=1,nsibsz+2
            if(iind.eq.1) then
               imum=0
               idad=0
               isex=2
            else if(iind.eq.2) then
               imum=0
               idad=0
               isex=1
            else
               idad=2
               imum=1
               isex=2
            end if
c     Genotypes of all loci (markers and QTLs)
            iallel=0
            do 62125 ichr=1,nchr
               do 62126 ilocus=1,nloc(ichr)
                  do 62127 iparen=1,2
                     iallel=iallel+1
                     genout(iallel)=
     $                    igeno(iind,iparen,ichr,ilocus)
62127             continue
62126          continue
62125       continue
            write(igenun,2777) k+ifamic,iind,idad,imum,isex,
     $           (genout(ij),ij=1,iallel)
c     Genotypes of just the QTLs
            iallel=0
            do 92125 ichr=1,nchr
               do 92126 iqtlct=1,nqtl(ichr)
                  do 92127 iparen=1,2
                     iallel=iallel+1
                     genout(iallel)=
     $                    qtlgty(k,iind,iparen,ichr,iqtlct)
92127             continue
92126          continue
92125       continue
            write(iqtlun,2777) k+ifamic,iind,idad,imum,isex,
     $           (genout(ij),ij=1,iallel)
62124    continue
 2777    format(i5,4i2,' 0 ',100i2)
c     this ends the loop for each family created
 374  continue
c
c
c     Now create qtl scores
c
c     For each family,
      do 43100 i=1,nfam
c     each member of the sibship,
         do 43105 ik=3,nsibsz+2
c     and each phenotype,
            do 43104 ij=1,npheno
               sumqtl=0d0
c     generate the additive QTL score
               do 43101 j=1,nchr
                  do 43102 k=1,nqtl(j)
                     sumqtl=sumqtl+qtles(j,k,
     $                    (qtlgty(i,ik,1,j,k)+qtlgty(i,ik,2,j,k)-1),ij)
43102             continue
43101          continue
c     and the epistatic QTL score.
               do 43103 l=1,nepipr
                  smpg1 = qtlgty(i,ik,1,iepi(l,1,1,ij),iepi(l,1,2,ij)) +
     $                 qtlgty(i,ik,2,iepi(l,1,1,ij),iepi(l,1,2,ij)) - 1
                  smpg2 = qtlgty(i,ik,1,iepi(l,2,1,ij),iepi(l,2,2,ij)) +
     $                 qtlgty(i,ik,2,iepi(l,2,1,ij),iepi(l,2,2,ij)) - 1
                  sumqtl = sumqtl + episcr(l,smpg1,smpg2,ij)
43103          continue
               qtlscr(i,ik-2,ij)=sumqtl
43104       continue
43105    continue
43100 continue
c
c     Now that we've assigned genetic values to all individuals,
c     we must calculate the genetic variance (of qtlscr, averaged
c     across all individuals) in order to determine the required
c     polygenic and shared and nonshared environmental variance
c     to add on.
c
      iind=0
      do 67091 ifam=1,nfam
         do 67092 isib=1,nsibsz
            iind=iind+1
            do 67093 ipheno=1,npheno
               tqtlsc(iind,ipheno)=qtlscr(ifam,isib,ipheno)
67093       continue
67092    continue
67091 continue
      nind=iind
c
      ifail=0
c     Get the qtl standard deviations, to be converted to variances.
      if(npheno.ge.2) then
         call g02baf(nind,npheno,tqtlsc,ndfam*ndsibz,xbar,std,
     $        ssp,ndphen,cormat,ndphen,ifail)
      else
         do 50701 iind=1,nfam*nsibsz
            tmp(iind)=tqtlsc(iind,1)
50701    continue
         ifail=0
         call g01aaf(nind,tmp,0,wt,xmean,s2,s3,s4,xmin,xmax,wtsum,
     $        ifail)
         std(1)=s2
      end if
c
c     Get phenotypic variance, polygenic variance, shared
c     environmental variance, and unique environmental variance
c
      do 67094 ipheno=1,npheno
         if(gsq(ipheno).le.0d0) then
            phvar=1d0
         else
            phvar=(std(ipheno)**2)/gsq(ipheno)
         end if
         polyv(ipheno)=hsq(ipheno)*phvar
         sharev(ipheno)=csq(ipheno)*phvar
         uniqv(ipheno)=(1-gsq(ipheno)-hsq(ipheno)-csq(ipheno))*phvar
67094 continue
c
c     Set up parameters to simulate polygenic and shared and
c     nonshared environmental deviations.
c
c     Compute the component covariance matrix from variances and
c     correlations.
c
      call dcmd(hrgh,polyv,plycor,npheno,ndphen)
      call dcmd(crcc,sharev,shrcor,npheno,ndphen)
      call dcmd(eree,uniqv,unicor,npheno,ndphen)
c
c     Now we can form the full expected covariance matrix among
c     sibs and phenotypes (excluding the QTL effects), of dimensions
c     nsibsz*npheno x nsibsz*npheno. This covariance matrix is
c     given as input to the multivariate normal random number
c     generator.
c
      do 3135 ioffst=0,(nsibsz-1)*npheno,npheno
         do 3136 joffst=0,(nsibsz-1)*npheno,npheno
            do 3137 iphen=1,npheno
               do 3138 jphen=1,npheno
                  if(ioffst.eq.joffst) then
                     covmat(iphen+ioffst,jphen+joffst)=
     $                    hrgh(iphen,jphen)+crcc(iphen,jphen)
     $                    +eree(iphen,jphen)
                  else
                     covmat(iphen+ioffst,jphen+joffst)=
     $                    .5d0*hrgh(iphen,jphen)+crcc(iphen,jphen)
                  end if
 3138          continue
 3137       continue
 3136    continue
 3135 continue
c
c     Call the nag routine to setup the data vector necessary
c     for simulation.
c
c     setup means to be zero
      do 3140 i=1,npheno*nsibsz
         a(i)=0d0
 3140 continue
      ifail=0
      call g05eaf(a,nsibsz*npheno,covmat,ndimc,
     $     1d-6,refvec,ndimrv,ifail)
c
c     Start a loop across all families to assign a phenotypic
c     score.
c
      do 9789 i=1,nfam
c
c     g05ezf uses results from g05eaf to do its thing.
c
         ifail=0
         call g05ezf(z,nsibsz*npheno,refvec,ndimrv,ifail)
         izcnt=0
         do 9759 j=1,nsibsz
            do 9760 k=1,npheno
               izcnt=izcnt+1
               phensc(i,j,k) = qtlscr(i,j,k) + z(izcnt)
 9760       continue
 9759    continue
 9789 continue
c
c     Initialize the phenotype type file with the number
c     of phenotypes.
      write(ipunit,*) npheno
c
c
c     Write out the genotype file.
c
      imiss=0
      do 88123 ifam=1,nfam
      do 88125 ichr=1,nchr
         do 88124 iind=1,nsibsz+2
            if(iind.eq.1) then
               imum=0
               idad=0
               isex=2
            else if(iind.eq.2) then
               imum=0
               idad=0
               isex=1
            else
               idad=2
               imum=1
               isex=2
            end if
            iallel=0
               do 88126 imarker=1,nmark(ichr)
                  do 88127 iparen=1,2
                     iallel=iallel+1
                     genout(iallel)=
     $                    genoty(ifam,iind,iparen,ichr,imarker)
88127             continue
88126          continue
            write(igunit+ichr,7777) ifam+ifamic,iind,idad,imum,isex,
     $           (genout(ij),ij=1,iallel)
            if(imum.eq.0.and.idad.eq.0) then
               write(ignpun+ichr,7777) ifam+ifamic,iind,idad,imum,isex,
     $              (imiss,ij=1,iallel)
            else
               write(ignpun+ichr,7777) ifam+ifamic,iind,idad,imum,isex,
     $              (genout(ij),ij=1,iallel)
            end if
            if(iind.eq.2) then
               write(ig1pun+ichr,7777) ifam+ifamic,iind,idad,imum,isex,
     $              (imiss,ij=1,iallel)
            else
               write(ig1pun+ichr,7777) ifam+ifamic,iind,idad,imum,isex,
     $              (genout(ij),ij=1,iallel)
            end if
88124    continue
88125 continue
c     Write the phenotype file.
         do 88128 isibn=1,nsibsz
            write(ipunit,8888) ifam+ifamic,isibn+2,
     $           (phensc(ifam,isibn,iphenc),iphenc=1,npheno)
88128    continue
88123 continue
 7777 format(i5,4i2,' 0 ',50i2)
 8888 format(i5,i2,6f11.5)
      return
      end
c
      subroutine rparam(gsq,qtles,qtlloc,marker,episcr,title,
     $     nchr,nmark,nqtl,nfam,nsel,iseed,nepipr,iepi,
     $     allfr,callfr,qtlfr,hsq,csq,nall,plycor,shrcor,
     $     unicor,nsibsz,npheno,ifamic)
c
c     This routine asks for and reads in the parameters for the
c     simulation
c
      implicit real*8 (a-h,o-z)
      parameter(ndmark=11,ndqtl=3,ndchr=2,ndeppr=6,ndall=9,ndphen=6)
      parameter(isdun=25)
      real*8 qtles(ndchr,ndqtl,3,ndphen),qtlloc(ndchr,ndqtl),
     $     marker(ndchr,ndmark),episcr(ndeppr,3,3,ndphen),
     $     allfr(ndchr,ndmark,ndall),callfr(ndchr,ndmark,ndall),
     $     qtlfr(ndchr,ndqtl),
     $     gsq(ndphen),hsq(ndphen),csq(ndphen),
     $     plycor(ndphen,ndphen),shrcor(ndphen,ndphen),
     $     unicor(ndphen,ndphen)
      integer nchr,nmark(ndchr),nqtl(ndchr),nfam,iepi(ndeppr,2,2,ndphen)
      integer nall(ndchr,ndmark),iepipr(ndphen)
      logical iepflg(ndchr,ndqtl,ndphen)
      character*72 title
      character*3 agen(3),bgen(3)
      open(isdun,file='seed.dat',status='old')
      agen(1)=' AA'
      agen(2)=' Aa'
      agen(3)=' aa'
      bgen(1)=' BB'
      bgen(2)=' Bb'
      bgen(3)=' bb'
c
c The variable iepflg is a flag for whether QTL j on chromosome i
c is one which interacts with another QTL.
c
      do 19999 j=1,ndqtl
         do 19998 i=1,ndchr
            do 19779 kk=1,ndphen
               iepflg(i,j,kk)=.false.
               do 20111 k=1,3
c Initialize qtles since for the second of a epistatic pair,
c qtles doesn't get any values below.
                  qtles(i,j,k,kk)=0d0
20111          continue
19779       continue
19998    continue
19999 continue
c
      print *, ' Multivariate sib-pair simulation program '
      print *,
     $ ' $Id: multisim.f,v 2.2 1998/03/23 18:35:46 cherny Exp $ '
      print *
      print *, ' Enter a title for this simulation: '
      read(*,45001) title
      print *, ' Enter the number of phenotypes: '
      read *, npheno
      do 9917 i=1,npheno
         print *, 'For phenotype ',i,': '
         print *,
     $        ' Enter the total broad-sense heritability for all QTL'
         read *, gsq(i)
         print *,
     $        ' Enter the polygenic heritability: '
         read *, hsq(i)
         print *,
     $        ' Enter the prop. of shared environmental variance: '
         read *, csq(i)
         testot=gsq(i)+hsq(i)+csq(i)
         if(testot.gt.1d0) then
            print *, ' *********** ERROR ************* '
            print *, ' Total proportions of variance sum to < 1. '
            print *, ' Program terminated. '
            stop
         end if
 9917 continue
      print *, ' Enter the polygenic correlation matrix'
      print *, ' (lower triangle): '
      do 90122 i=2,npheno
         read *, (plycor(i,j),j=1,i-1)
90122 continue
      print *, ' Enter the shared environmental correlation matrix'
      print *, ' (lower triangle): '
      do 90123 i=2,npheno
         read *, (shrcor(i,j),j=1,i-1)
90123 continue
      print *, ' Enter the unique environmental correlation matrix'
      print *, ' (lower triangle): '
      do 90124 i=2,npheno
         read *, (unicor(i,j),j=1,i-1)
90124 continue
      do 90125 i=2,npheno
         do 90126 j=1,i-1
            plycor(j,i)=plycor(i,j)
            shrcor(j,i)=shrcor(i,j)
            unicor(j,i)=unicor(i,j)
90126    continue
90125 continue
      do 90127 i=1,npheno
         plycor(i,i)=1d0
         shrcor(i,i)=1d0
         unicor(i,i)=1d0
90127 continue
      print *, ' Enter the number of chromosomes to be simulated: '
      read *, nchr
      do 13445 i=1,ndphen
         iepipr(i)=0
13445 continue
      do 99 j=1,nchr
         print *, ' Enter the number of markers on chromosome ',j,': '
         read *, nmark(j)
         do 75 i=1,nmark(j)
            print *, ' Enter the distance (in cM) from the beginning of'
            print *, ' chromosome ',j,' of marker number ',i,': '
            read *, marker(j,i)
            print *, ' Enter the number of alleles marker '
            print *, ' number ',i,' on chromosome ',j,'has: '
            read *, nall(j,i)
            print *, ' Enter the allele frequencies, one per line: '
            runtot=0d0
            do 9975 kkj=1,nall(j,i)
               read *, allfr(j,i,kkj)
               runtot=runtot+allfr(j,i,kkj)
               callfr(j,i,kkj)=runtot
 9975       continue
            if(runtot.gt.1.00001d0.or.runtot.lt.0.99999d0) print *,
     $           ' Warning, allele frequencies do not sum to 1!!! '
 75      continue
         print *, ' Enter the number of QTLs on chromosome ',j,': '
         read *, nqtl(j)
         do 85 i=1,nqtl(j)
            print *, ' Enter the position of QTL',i,' on chromosome ',
     $           j,': '
            read *, qtlloc(j,i)
            print *, ' Enter the frequency of the decreasing allele for'
            print *, ' QTL',i,' on chromosome ',j,': '
            read *, qtlfr(j,i)
            do 8010 ijjj=1,npheno
               if(.not.iepflg(j,i,ijjj)) then
                  print *, ' With respect to phenotype ',ijjj,','
                  do 8000 ikkk=1,3
                     print *, ' Enter the mean for genotype',agen(ikkk)
                     print *, ' of QTL',i,' on chromosome ',j
                     print *, ' If epistatic, enter 0: '
                     read *, qtles(j,i,ikkk,ijjj)
 8000             continue
               end if
c     If all zeros and not yet flagged for epistasis, do:
               if ((qtles(j,i,1,ijjj).eq.0d0
     $              .and.qtles(j,i,2,ijjj).eq.0d0
     $              .and.qtles(j,i,3,ijjj).eq.0d0)
     $              .and.(.not.iepflg(j,i,ijjj))) then
                  iepipr(ijjj)=iepipr(ijjj)+1
c     Doesn't look like the present iepflg needs to be reset, but
c     let's do it anyway.
                  iepflg(j,i,ijjj)=.true.
                  iepi(iepipr(ijjj),1,1,ijjj)=j
                  iepi(iepipr(ijjj),1,2,ijjj)=i
                  print *, ' Enter the chromosome number of the QTL',
     $                 ' with which this QTL interacts: '
                  read *, iepi(iepipr(ijjj),2,1,ijjj)
                  print *, ' Enter the number of the QTL on chromosome',
     $                 iepi(iepipr(ijjj),2,1,ijjj)
                  print *, ' with which this QTL interacts: '
                  read *, iepi(iepipr(ijjj),2,2,ijjj)
                  iepflg(iepi(iepipr(ijjj),2,1,ijjj),
     $                 iepi(iepipr(ijjj),2,2,ijjj),ijjj)
     $                 =.true.
               end if
 8010       continue
 85      continue
 99   continue
      do 80124 ijjj=1,npheno
      nepipr=iepipr(ijjj)
      print *, ' With respect to phenotype ',ijjj,','
      do 55990 ii=1,nepipr
         do 55991 iii=1,3
            do 55992 jjj=1,3
               print *, ' For epistatic pair',ii,', enter the mean for'
               print *, ' genotype',agen(iii),bgen(jjj),': '
               read *, episcr(ii,iii,jjj,ijjj)
55992       continue
55991    continue
55990 continue
80124 continue
      print *
      print *, ' How many families to be simulated? '
      read *, nfam
      print *, ' Enter the sibship size: '
      read *, nsibsz
      print *, ' Increment family counter by? '
      read *, ifamic
      read(isdun,*) iseed
      print *, '======================================================='
      print *, ' Your simulation parameters for job '
      print *, title,': '
      do 74771 jh=1,npheno
         print *, ' For phenotype ',jh,': '
         print *, ' Broad-sense heritability is ',gsq(jh),'.'
         print *, ' Polygenic heritability is ',hsq(jh),'.'
         print *, ' Prop. of shared env variance is ',csq(jh),'.'
74771 continue
      print *, ' Polygenic correlation matrix: '
      do 70123 i=1,npheno
         print *, (plycor(i,j),j=1,npheno)
70123 continue
      print *, ' Shared environmental correlation matrix: '
      do 70124 i=1,npheno
         print *, (shrcor(i,j),j=1,npheno)
70124 continue
      print *, ' Unique environmental correlation matrix: '
      do 70125 i=1,npheno
         print *, (unicor(i,j),j=1,npheno)
70125 continue
      print *, ' Number of chromosomes: ', nchr
      do 799 j=1,nchr
         print *, ' Number of markers: ', nmark(j)
         print *, ' Marker positions on chromosome ',j,': '
         do 86 i=1,nmark(j)
            print *, ' Marker ', i, ' is at', marker(j,i), ' cM'
 86      continue
         print *, ' Number of QTLs on chromosome ',j,': ', nqtl(j)
         do 87 i=1,nqtl(j)
            print *, ' QTL',i,' is at',qtlloc(j,i),'.'
            do 8790 ijij=1,npheno
               if(.not.iepflg(j,i,ijij)) then
                  print *, ' For phenotype ',ijij,' it'
                  do 8788 ikkk=1,3
                     print *, ' has a mean of ',qtles(j,i,ikkk,ijij),
     $                    ' for genotype',agen(ikkk)
 8788             continue
               end if
 8790       continue
 87      continue
 799  continue
c
      do 80324 ijjj=1,npheno
      nepipr=iepipr(ijjj)
      do 66990 ii=1,nepipr
         print *, ' With respect to phenotype ',ijjj,','
         do 66991 iii=1,3
            do 66992 jjj=1,3
               print *, ' For epistatic pair',ii,', the mean for'
               print *, ' genotype',agen(iii),bgen(jjj),' is: ',
     $              episcr(ii,iii,jjj,ijjj)
66992       continue
66991    continue
66990 continue
80324 continue
      print *, ' The seed used is: ', iseed
      print *, ' Your simulation consists of', nfam, ' families'
      print *, ' of sibships of size', nsibsz, '.'
      print *, ' Your marker data will be written to ./pedigree.dat '
      print *, ' Your phenotypes will be written to ./pheno.dat '
      print *, ' Complete genotypes, including the QTLs, are written '
      print *, ' to ./genotypes.dat '
      print *, ' QTL genotypes are written to ./qtl-genotypes.dat '
      print *, ' Complete information genotypes for all markers and '
      print *, ' QTLs are written to ./complete-info.dat '
      print *, ' Complete information genotypes for just the markers '
      print *, ' are written to ./complete-marker-info.dat '
      print *, ' Genotypes with parental genotypes omitted are '
      print *, ' written to ./no-parents.dat '
      print *, ' Genotypes with father genotypes omitted are '
      print *, ' written to ./one-parent.dat '
      return
45001 format(a72)
      end
c
      subroutine getvar(x,var,n,ndim)
      implicit real*8 (a-h,o-z)
      real*8 x(ndim)
      sum=0d0
      ssq=0d0
      do 9456 i=1,n
         sum = sum + x(i)
         ssq = ssq + x(i)**2
 9456 continue
      var = ( ssq - (sum**2 / n) ) / (n-1)
      return
      end
c
c     This function generates random genotypes based on
c     allele frequencies.
c
      integer function irgen(cfr,nall,ndall)
      implicit real*8 (a-h,o-z)
      real*8 cfr(ndall)
      dice=g05caf(x)
      do 1001 i=1,nall
         if(dice.le.cfr(i)) then
            irgen=i
            go to 1002
         end if
 1001 continue
 1002 return
      end
c
c     This subroutine pre- and postmultiplies a square matrix
c     by a diagonal matrix. e.g. creates hRgh from h and Rg.
c
      subroutine dcmd(x,v,r,n,ndim)
      implicit real*8 (a-h,o-z)
      real*8 v(ndim),r(ndim,ndim),x(ndim,ndim)
      do 1010 i=1,n
         do 1020 j=1,n
            x(i,j)=dsqrt(v(i))*r(i,j)*dsqrt(v(j))
 1020    continue
 1010 continue
      return
      end
